Attribute VB_Name = "mdCreateLinePointToPoint"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Conveniece Function to create a line between two points

Function CreateLinePointToPoint(startpoint As aPoint, endpoint As aPoint)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim startvector As ZVector
Set startvector = startpoint.GetPosition

Dim endvector As ZVector
Set endvector = endpoint.GetPosition

If (startvector.IsEqualTo(endvector)) Then
    Set CreateLinePointToPoint = Nothing
    MsgBox "Invalid Inputs: The StartPoint and the EndPoint of the line are same"
    Exit Function
End If

Dim curve As zCurve
Set curve = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(startvector, endvector)

Dim lineObj As aLine
Set lineObj = sketch.CreateLine(curve)

wp.AutoConstrain lineObj

Set CreateLinePointToPoint = lineObj

End Function
